/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.tank.data;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.deepresonance.modules.tank.data.DRTankNetwork;
import mcjty.deepresonance.modules.tank.data.TankBlob;
import mcjty.deepresonance.util.LiquidCrystalData;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class DRTankHandler
implements IFluidHandler,
IFluidTank {
    private final Level level;
    private final Supplier<Integer> blobIdGetter;
    private final Supplier<LiquidCrystalData> clientDataGetter;

    public DRTankHandler(Level level, Supplier<Integer> blobIdGetter, Supplier<LiquidCrystalData> clientDataGetter) {
        this.level = level;
        this.blobIdGetter = blobIdGetter;
        this.clientDataGetter = clientDataGetter;
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    private LiquidCrystalData getData() {
        if (this.level.f_46443_) {
            return this.clientDataGetter.get();
        }
        TankBlob blob = DRTankNetwork.getNetwork(this.level).getBlob(this.blobIdGetter.get());
        if (blob == null) {
            return LiquidCrystalData.EMPTY;
        }
        return blob.getData();
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.getData().getFluidStack();
    }

    public int getTankCapacity(int tank) {
        if (this.level.f_46443_) {
            return 10000;
        }
        TankBlob blob = DRTankNetwork.getNetwork(this.level).getBlob(this.blobIdGetter.get());
        if (blob != null) {
            return blob.getCapacity();
        }
        return 0;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return true;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.level.f_46443_) {
            return 0;
        }
        TankBlob blob = DRTankNetwork.getNetwork(this.level).getBlob(this.blobIdGetter.get());
        if (blob != null) {
            int filled = blob.fill(resource, action);
            if (filled > 0 && action.execute()) {
                this.onUpdate();
            }
            return filled;
        }
        return 0;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.level.f_46443_) {
            return FluidStack.EMPTY;
        }
        TankBlob blob = DRTankNetwork.getNetwork(this.level).getBlob(this.blobIdGetter.get());
        if (blob != null) {
            FluidStack drained = blob.drain(resource, action);
            if (!drained.isEmpty() && action.execute()) {
                this.onUpdate();
            }
            return drained;
        }
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.level.f_46443_) {
            return FluidStack.EMPTY;
        }
        TankBlob blob = DRTankNetwork.getNetwork(this.level).getBlob(this.blobIdGetter.get());
        if (blob != null) {
            FluidStack drained = blob.drain(maxDrain, action);
            if (!drained.isEmpty() && action.execute()) {
                this.onUpdate();
            }
            return drained;
        }
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack getFluid() {
        if (this.level.f_46443_) {
            return this.clientDataGetter.get().getFluidStack();
        }
        return this.getData().getFluidStack();
    }

    public int getFluidAmount() {
        if (this.level.f_46443_) {
            return this.clientDataGetter.get().getFluidStack().getAmount();
        }
        return this.getData().getAmount();
    }

    public int getCapacity() {
        if (this.level.f_46443_) {
            return 10000;
        }
        TankBlob blob = DRTankNetwork.getNetwork(this.level).getBlob(this.blobIdGetter.get());
        if (blob != null) {
            return blob.getCapacity();
        }
        return 0;
    }

    public boolean isFluidValid(FluidStack stack) {
        return true;
    }

    public void onUpdate() {
    }
}

